#ifndef PRIMITIVE_H
#define PRIMITIVE_H

#include "../common/structs.h"


typedef struct
{
	char *type;
	int obj_id;

	vector* (*normal) (point* p, void* obj, vector* v);
	
	double (*intersect) (point* startP, vector* projV,
						 void* obj, point* pntIntersect);
	
	//polygon generator
	
} primitive_type;

typedef struct
{
	char *name;
	int obj_id;

	vector position;
	void *rotation;
	void *data;
	void *polygons;

	//common attributes
	char shadow;  //casts, accepts, casts+accepts, no_shadows
	
	//shader instance list
	
	vector* (*normal) (point* p, void* obj, vector* v);
	
	double (*intersect) (point* startP, vector* projV, void* obj, point* pntIntersect);
	
	void* (*shader) (void *id, color *new_color);
} primitive;



#endif
